<?php include('includes/header.php'); ?>

<section class="py-5 mt-5">
    <div class="container pt-5">
        <div class="row border-bottom border-secondary pb-5 mb-5">
            <div class="col-lg-10">
                <h6 class="text-success text-uppercase fw-bold tracking-widest mb-3">Our Mission</h6>
                <h1 class="display-2 fw-bold text-white mb-0">Building the <span class="italic text-white-50">Backbone</span> of the Decentralized Web.</h1>
            </div>
        </div>

        <div class="row g-5">
            <div class="col-md-4">
                <p class="small text-success text-uppercase fw-bold tracking-widest">01. Scalability</p>
                <p class="text-white-50">We believe infrastructure should be invisible. Our systems auto-scale based on load, ensuring your users never experience a millisecond of lag.</p>
            </div>
            <div class="col-md-4">
                <p class="small text-success text-uppercase fw-bold tracking-widest">02. Security</p>
                <p class="text-white-50">Encryption isn't a feature; it's a foundation. Every packet moving through the ColorChalk network is encrypted end-to-end.</p>
            </div>
            <div class="col-md-4">
                <p class="small text-success text-uppercase fw-bold tracking-widest">03. Open Source</p>
                <p class="text-white-50">Our core SDKs are open-source. We believe in building in public and contributing back to the developer community.</p>
            </div>
        </div>
    </div>
</section>

<section class="py-5 bg-black border-top border-secondary">
    <div class="container py-5">
        <div class="row mb-5 align-items-center">
            <div class="col-md-6">
                <h2 class="display-6 fw-bold text-white">The <span class="mono">Stack</span></h2>
                <p class="text-white-50">We utilize the most robust technologies to ensure your data stays consistent and available.</p>
            </div>
        </div>

        <div class="row g-3">
            <div class="col-6 col-md-3">
                <div class="bento-card p-4 text-center">
                    <i class="bi bi-database text-success fs-2 mb-3 d-block"></i>
                    <span class="mono small text-white">PostgreSQL</span>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="bento-card p-4 text-center">
                    <i class="bi bi-diagram-3 text-success fs-2 mb-3 d-block"></i>
                    <span class="mono small text-white">Redis Cache</span>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="bento-card p-4 text-center">
                    <i class="bi bi-shield-check text-success fs-2 mb-3 d-block"></i>
                    <span class="mono small text-white">Cloudflare</span>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="bento-card p-4 text-center">
                    <i class="bi bi-code-slash text-success fs-2 mb-3 d-block"></i>
                    <span class="mono small text-white">TypeScript</span>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="py-5">
    <div class="container py-5">
        <div class="bento-card p-5 overflow-hidden position-relative">
            <div class="row align-items-center">
                <div class="col-lg-7">
                    <h2 class="display-6 fw-bold text-white mb-4">Remote by Design. <br>Global by Nature.</h2>
                    <p class="text-white-50 mb-0">Our engineering team is distributed across 14 countries, working around the clock to maintain the pulse of the internet. We aren't just a company; we're a protocol.</p>
                </div>
                <div class="col-lg-5 text-lg-end mt-4 mt-lg-0">
                    <a href="contact.php" class="btn btn-outline-success px-5 py-3 rounded-0">Join the Collective</a>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include('includes/footer.php'); ?>